//package stepcontrol;

import java.awt.Button;
import java.awt.Component;
import java.awt.Event;
import java.awt.GridBagConstraints;
import java.awt.Label;
import misc.Debug;
import java.awt.Panel;
import java.awt.*;

/**
 * A Control object controls the execution speed of application objects.
 * The speed is measured in steps per second. At every crucial point in the
 * applicaton object (e.g. loop iteration), a call to waitNextStep() has to
 * placed. When setSteps() is called with argument 0, a single step of the
 * application object is allowed. A corresponding object of type
 * StepControlPanel belongs to the objects and allows for adjusting the
 * speed.
 *
 * @version 0.10 12 Mai 1997
 * @author Gunter Weiss
 */
public class StepControl extends Panel {

  private protected Button stepButton;
  protected  StepControl stcontrol;
  protected Scrollbar slider1;
  private Label label1;
  //private protected StepControlPanel steppanel;
  protected int steps;
  protected String name = "Control Slider";

/**
 * @param steps Initial number of steps per second.
 */
	public StepControl( int steps ) {
		this .steps = steps;
		this .name = "Step-Control ";
	}

/**
 * @param steps Initial number of steps per second.
 * @param name The name of the object as an identification for a window.
 */
	public StepControl( int steps, String name ) {

	  this .steps = steps;
	  this .name = name;

	  setLayout( new GridLayout(3,1,3,3 ));
	  label1 = new Label("Steps/s",Label.CENTER);
	  label1. setFont(new Font("Courier",Font.PLAIN,12));
	  slider1 = new Scrollbar( Scrollbar.HORIZONTAL, 0, 5, 0, 10 ) ;
	  stepButton = new Button("Step");
	  add(label1);
	  add(slider1);
	  add(stepButton);
	  validate();
	  show();
	}
/**
 * Called by application object to wait for next execution step
 */
	public void waitNextStep() {
		// It's important that not the whole method is protected, because other
		// threads might want to call it while a thread is sleeping.
		synchronized( this ) {
			while ( steps == 0 ) {
				try { this.wait(); } catch ( InterruptedException i ) { ; }
				return;
			}
		}
		try { Thread.sleep( 1000 / steps ); } catch ( InterruptedException i ) { ; }
	}


/**
 * Adjusts the execution speed. If called with argument 0 while the current
 * value is 0, then a single step will be executed.
 */
	protected synchronized void setSteps( int new_steps ) {
		int old_steps = steps;
		steps = new_steps;
		label1.setText(steps +" Steps/s");
		if ( old_steps == 0 ) {
			this.notifyAll();
		}
	}

  /**
  * Overrides action() of class Component.
  */
	public boolean action( Event e, Object arg ) {
		if ( e.target == stepButton ) {
		   setSteps(slider1.getValue());
		   System .out.println("Control: " + name + " " + slider1.getValue());
		   return true;
		}
		return super.action( e, arg );
	}
  /**
  * Overrides handleEvent() of class Component.
  */
    public boolean handleEvent(Event event) {
		if ( event.target == slider1 ) {
		   setSteps(slider1.getValue());
		   return true;
		}
		return super.handleEvent( event );
	}

	public void finish() {
	  //super.finish();
		slider1 = null;
		stepButton = null;
		Debug.out( "StepControlpanel.finish: called" );
	}

	protected void finalize() {
		Debug.outa("StepControlpanel.finalize called");
		try { super.finalize(); } catch ( Throwable _x ) { ; }
	}
} // End of class Control


